/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core.model;

import com.aptana.core.IMap;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.SourcePrinter;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.IndexUtil;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.js.core.inferencing.JSTypeUtil;
import com.aptana.js.core.model.ExceptionElement;
import com.aptana.js.core.model.ParameterElement;
import com.aptana.js.core.model.PropertyElement;
import com.aptana.js.core.model.ReturnTypeElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionElement
extends PropertyElement {
    private static final String REFERENCES_PROPERTY = "references";
    private static final String EXCEPTIONS_PROPERTY = "exceptions";
    private static final String RETURN_TYPES_PROPERTY = "returnTypes";
    private static final String PARAMETERS_PROPERTY = "parameters";
    private static final String IS_METHOD_PROPERTY = "isMethod";
    private static final String IS_CONSTRUCTOR_PROPERTY = "isConstructor";
    private List<ParameterElement> _parameters;
    private List<String> _references;
    private List<ExceptionElement> _exceptions;
    private List<ReturnTypeElement> _returnTypes;
    private boolean _isConstructor;
    private boolean _isMethod;

    public FunctionElement() {
    }

    public FunctionElement(FunctionElement base) {
        super(base);
        this._parameters = new ArrayList<ParameterElement>(base.getParameters());
        this._references = new ArrayList<String>(base.getReferences());
        this._exceptions = new ArrayList<ExceptionElement>(base.getExceptions());
        this._returnTypes = new ArrayList<ReturnTypeElement>(base.getReturnTypes());
        this._isConstructor = base.isConstructor();
        this._isMethod = base.isMethod();
    }

    public void addException(ExceptionElement exception) {
        if (exception != null) {
            if (this._exceptions == null) {
                this._exceptions = new ArrayList<ExceptionElement>();
            }
            this._exceptions.add(exception);
        }
    }

    public void addParameter(ParameterElement parameter) {
        if (parameter != null) {
            if (this._parameters == null) {
                this._parameters = new ArrayList<ParameterElement>();
            }
            this._parameters.add(parameter);
        }
    }

    public void addReference(String reference) {
        if (reference != null && reference.length() > 0) {
            if (this._references == null) {
                this._references = new ArrayList<String>();
            }
            this._references.add(reference);
        }
    }

    public void addReturnType(ReturnTypeElement returnType) {
        if (returnType != null) {
            int index;
            if (this._returnTypes == null) {
                this._returnTypes = new ArrayList<ReturnTypeElement>();
            }
            if ((index = this._returnTypes.indexOf(returnType)) != -1) {
                this._returnTypes.set(index, returnType);
            } else {
                this._returnTypes.add(returnType);
            }
        }
    }

    public void addReturnType(String type) {
        if (type != null && type.length() > 0) {
            ReturnTypeElement returnType = new ReturnTypeElement();
            returnType.setType(type);
            this.addReturnType(returnType);
        }
    }

    @Override
    public void fromJSON(Map object) {
        super.fromJSON(object);
        this.setIsConstructor(Boolean.TRUE == object.get(IS_CONSTRUCTOR_PROPERTY));
        this.setIsMethod(Boolean.TRUE == object.get(IS_METHOD_PROPERTY));
        this._parameters = IndexUtil.createList(object.get(PARAMETERS_PROPERTY), ParameterElement.class);
        this._returnTypes = IndexUtil.createList(object.get(RETURN_TYPES_PROPERTY), ReturnTypeElement.class);
        this._exceptions = IndexUtil.createList(object.get(EXCEPTIONS_PROPERTY), ExceptionElement.class);
        this._references = IndexUtil.createList(object.get(REFERENCES_PROPERTY));
    }

    public List<ExceptionElement> getExceptions() {
        return CollectionsUtil.getListValue(this._exceptions);
    }

    public List<String> getExceptionTypes() {
        return CollectionsUtil.map(this.getExceptions(), (IMap)new IMap<ExceptionElement, String>(){

            public String map(ExceptionElement exception) {
                return exception.getType();
            }
        });
    }

    public List<String> getParameterNames() {
        return CollectionsUtil.map(this.getParameters(), (IMap)new IMap<ParameterElement, String>(){

            public String map(ParameterElement parameter) {
                return parameter.getName();
            }
        });
    }

    public List<ParameterElement> getParameters() {
        return CollectionsUtil.getListValue(this._parameters);
    }

    public List<String> getParameterTypes() {
        return CollectionsUtil.map(this.getParameters(), (IMap)new IMap<ParameterElement, String>(){

            public String map(ParameterElement parameter) {
                return StringUtil.join((String)"|", parameter.getTypes());
            }
        });
    }

    public List<String> getReferences() {
        return CollectionsUtil.getListValue(this._references);
    }

    public List<String> getReturnTypeNames() {
        return CollectionsUtil.map(this.getReturnTypes(), (IMap)new IMap<ReturnTypeElement, String>(){

            public String map(ReturnTypeElement type) {
                return type.getType();
            }
        });
    }

    public List<ReturnTypeElement> getReturnTypes() {
        return CollectionsUtil.getListValue(this._returnTypes);
    }

    public boolean hasExceptions() {
        return !CollectionsUtil.isEmpty(this._exceptions);
    }

    public boolean hasParameters() {
        return !CollectionsUtil.isEmpty(this._parameters);
    }

    public boolean isConstructor() {
        return this._isConstructor;
    }

    public boolean isMethod() {
        return this._isMethod;
    }

    public void setIsConstructor(boolean value) {
        this._isConstructor = value;
    }

    public void setIsMethod(boolean value) {
        this._isMethod = value;
    }

    @Override
    public void toJSON(JSON.Output out) {
        super.toJSON(out);
        out.add(IS_CONSTRUCTOR_PROPERTY, this.isConstructor());
        out.add(IS_METHOD_PROPERTY, this.isMethod());
        out.add(PARAMETERS_PROPERTY, this.getParameters());
        out.add(RETURN_TYPES_PROPERTY, this.getReturnTypes());
        out.add(EXCEPTIONS_PROPERTY, this.getExceptions());
        out.add(REFERENCES_PROPERTY, this.getReferences());
    }

    @Override
    public void toSource(SourcePrinter printer) {
        printer.printIndent();
        if (!this.isInstanceProperty()) {
            printer.print("static ");
        }
        if (this.isInternal()) {
            printer.print("internal ");
        }
        if (this.isConstructor()) {
            printer.print("constructor ");
        }
        if (this.isMethod()) {
            printer.print("method ");
        }
        printer.print(this.getName());
        printer.print('(').print(StringUtil.join((String)",", this.getParameterTypes())).print(')');
        List<String> returnTypes = this.getReturnTypeNames();
        printer.print(":");
        if (!CollectionsUtil.isEmpty(returnTypes)) {
            printer.print(StringUtil.join((String)",", returnTypes));
        } else {
            printer.print("undefined");
        }
        if (this.hasExceptions()) {
            printer.print(" throws ").print(StringUtil.join((String)", ", this.getExceptionTypes()));
        }
    }

    @Override
    public String toString() {
        SourcePrinter printer = new SourcePrinter();
        this.toSource(printer);
        return printer.toString();
    }

    public List<String> getSignatureTypes() {
        ArrayList<String> types = new ArrayList<String>(this.getTypeNames());
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            if (!((String)iter.next()).startsWith("Function")) continue;
            iter.remove();
            break;
        }
        types.add(JSTypeUtil.toFunctionType(this.getReturnTypeNames()));
        return types;
    }

    @Override
    public List<String> getTypeNames() {
        return super.getTypeNames();
    }
}

